#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="3546258483"
MD5="c7bdbe4e9dca82e1e810be2b32cedd20"
TMPROOT=${TMPDIR:=/tmp}

label="Systembase PCI/PCIe device drvier installer"
script="./Install"
scriptargs=""
targetdir="sysbas_mpdrv.v20.2"
filesizes="44196"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 272 KB
	echo Compression: bzip2
	echo Date of packaging: Fri Feb  7 11:40:33 KST 2014
	echo Built with Makeself version 2.1.5 on 
	echo Build command was: "./makeself-2.1.6/makeself.sh \\
    \"--bzip2\" \\
    \"sysbas_mpdrv.v20.2\" \\
    \"sysbas_mpdrv.v20.2.sh\" \\
    \"Systembase PCI/PCIe device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"sysbas_mpdrv.v20.2\"
	echo KEEP=y
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=272
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 272 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 272; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (272 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYl= |xߞ=ۂ@}=Ά:(^ݍwv<nǝY|fӭm }ןz   =*0k3d
,WrlOx_os.	vi2>^^Ϸ,w{Kl6m^}s{y^f2twpxIEBlx>Iou%뇻׽{gnw1G_v>cE t2_Oq}k|޽=Ʈx㶧//MӻyUk>{z7ts̽}W}{ֽ㝫+Yv綵ݼv<eBPϰi.O}yjz;l_wpnU}>Aopؾ]uuhuݏw[hl绒_X>os]{i3秦ֻsi=w/}}Nƻ黾<oqy@_Vh=[w}wZ^wo o^	" 1
  	hh4@h00LL)	Mm4d#ƀc)mơi	LFF& &#SOʞS6h?TzSj4 4

4CC@24P 4 
@Hi0Ihʛ5OMO
Cѵz=OP
  4z             $"h&#=3M F$
O)hSCPd6z h     (z  $j6#&ѡ=*mO=hњؐoTSi=S
{Jo*lzMOȍM4&	̣FP4<#Mh
$B F Li=	zdRl=T$5?!ISAh  d  @       hkyH^(;h/*9ۈZmkΰ^?1tEs//4V]WW ]92LR%̓)@Ebba)]}38B5:Ņ֩Vh-nB6Mj,5=ztaTk-KCD[IѓbS6]o
!;Ë;L}W,:"ƼUMJyM(pfʿny[%!8vY7*QTcDTDfV?'0X?O,7$uzpVa`/
/Xu^ϑw{xe|o9<C=9Y+{g>]V{;\ֽ>>MqX7p|O6NU~Q
0:-W0Ϯ-9yw`*CNC=3yM5(?G&r_=;;B-b
xŹ@%]V	B; 덤 dS)LI9,Z|_zX9_3Wb
}Jt!GLiWJߜlqE$yĳY$*g9@6")6k9nx9zba!ffL۪Aq2Be_q0՟|5ڝUMR]пP}i
v>軀^~z@?#l_tc'[yXEzO-9gAoJij2;,gffP]i׎ج+x>lG~~s\[!1&2'
b	/2$QT|\ɔڗɴd"V}_C_蚂fgy'%
>5NHmU ryP^0K;Lma
G.8/y4EKU{VGv%@D j4m8ۓavYjDs"kyf2sj~ʿFNt1>OHgP'tr',F:^*3*U<acp;Ύ]q
\@/U'¯~>:Zy\LQ?K촻EȃC~G2XU[Xjz+T~ْ*ڑuSn1(Y$$$-iL()IIIIIJ3: 醘XFi$!%곑jNiR*je*h7TyK>WJrF$yQ2vO?1B!7?gixGMSAvća޼aUԒQWLGyU6KRw2a3Y;3l?_wf9\w631?4y>ohنzqb(S˝yJ&8,:Wi :|n?9!ó,5,H;Nm6YifYz_M/k[N,[YDq8#ԶI6ClcXZI4D4wֱ0-"u;h$L6
FJ&HXLYyMmm6mΘŭiKbƎ960g9ͭ}k3:^i.eQMgZvLÚ@=WHS |l[rQL`b-(7 ~̈7)LǙM&H!J6gC0Cᇨ^	4blZr2 C,uR/,(zʅ[׹}zcT?<XUHL[ߑ0~˘Y΋,[unjky.UV#`QɆe
s%5nc
h::nW\TGEƺ񃤾~4L}[rM}N,@0cc(9Htpk:{843C#.u|Ĥ`ÿX7pǌ#3Kzmh]xctk]e!ZY3S36Shy`W=$VڏY\_9Q!MCaqΡ)wva30B
o1Q{#ݯS
_U<'5#	A#>9[CKF_|+TQ!M{NVz$fpnBHAffd;4bS'$BO5q1#k[<<cj?9ua䅳#I`ׄ#^
MI(1ֵax:ZkMz݆|By#k.~
u9׻j[dkt~՞v|$2A$w@R-G)5cNIzURߵmЎpբo{'KHs8;u[{P3I:~>O_zaNI2ј68f.DzLi]٠LI!kMriq'5}ze 0!5ɪH+`7f8VPH?ȄAsF%4<݄&4ĂYذ74L<q=b'L8%"йU3pƇ|qzYv
00$/^dIv,	~rpt!"&̃ѕPqL`Ӄ1Lsg~#g >pS\)\ᰝLCE7)#З/ҟ~OxثVJS^	Gdl3?^c GsBs\!qG|g=Ew9C]\:vHj^Iޝ CG:HPXGtfI>u*>Z	^Xmo: K^Rp@n	xY7\B>{D-udx!<rg<Gg-=
"qBpiv!p>~XWB]=ܿ;WAHBǵ}gG]۶cw(Rּe4Ukhv+μb8Q)0عepǂ.֙ýf*,&.A8I
Ōes6KY iFt-$2
n8SR,ض(!2\ﾻwJb&9ف#2yd!I4%?xI9\ 'Yہ22#Ty,oϷɽ|tCTl9%
ut wYs0SJ(  *I` H>OZ0e?d6B?	vJvA: @b/ꉠ> OJHyB ";Us_>{(&C?! z=VlYɓhzey`z4L
기Td JdH!LPڭ~LW<	>VtTwWom|ZC%v_L\Op@j>X}0C4?~~{Mx}/d-.IC7hrqԆuM[y'{4gFF1c?ٹ_tCVEtYB mlW~F3?d5!3'`@j}x8:NE9qC:< _L\ _׫]J']v?þ{W}?
O>_ZT1̀F%ge	; @ 1~{M~iv{pw#o|/y>I5?1煉{i0'w&nzQΩQ'ZS{y|c[\t}C[qoxWǧQo/s@jdgl}k"@`&Cނ?t
L IϤ0WL?rWG='$dRg_jrwW=G}q?q?8ׇt3w?Mu?uާtIz;]K~֛Ў_v'e<̓333"y*0oR
OӄӣsV&7(>Su*(.0yA?C01L~daʙҾ_%d40`8!}?.>grw;lq=wM}K<oq_+vW{S;`sT3֋yvqPr0"@f?YjrWB&e}_"8i-zmqqe+uI~tg9f8.F26ml&	ۥ"2H>.:?n[8y0er];-[oh]l0	OOyZEǢ76
R&&As95媊4'*2vrG%[[Oj"tw40I%vtÓ=ݮ1zQ+6FOPi_hq4LA
;;Fc`~R1AY5_@P+4`y}Su?/I?vׇ׎ÍL;x<#C؀b>L>p˅ ;zd^B0LjG;_߲:q_GTO?vkC BL 
 rE2ߌ)|pW;7?__>p!LLcX:HeRCh?N~ l`>ƇfsIy;=濣k:~eKLDZQ@c4=X>T&h*P@@ʸ$bOd_܌H3BSjd9f+P;8.xs脁DQPP?ܱ]Fc*3q;*uwOA6:4y>2(2aD(AP?Lq4YC$}d,T!$ rOǑȇ|;蒘 Id3
c5[
)$vSI|ٶI7_6͎Hʩ*}OсDBw)5_??;^:V<33cű4qi-6
zk,^%A7ɊlM3:-k`بBswӵxsFA"'@LLʡ0NQ#E0@3Ya3Q4UJuF1$JT$PD3j(1iU_Ӄ2HQMƪJ$f`M4`14I% SA-3A
CA@S	@R.xʊLTaS_ EDDEJ@QIrGB:Y0'댝1@WL3֖ܰY@̐Ød)21勾'KZP+q⩛a$|>[wK#{7eZLl<UE5

bc|01Lf'i"$im9[ɺ_v>RqVČi.C+ h>xM$?o}KA=p	z>uo4gy#
ӕ6.Bm{gnڄ) !@kӨB 0E@Iq3F;lem	THQPQD-q0БRLTC)3RRDK$E,̕15TC5=EAAK@BAK5,;U
Uk1
*F)狅IDnaL%-ıSPف9	57LLK'"f	 *()di

R(b&VyF0HJ2AM4W[~Hr7a(!()b&*$"X &b hb	ihZT	g
C3eM
PRҔM	L0EA0B
 HM$MR-E4H)@1R LT0BG>_{OVoxu$T>W|(o;^A|O%&
d.S96
(1߫;oI`O|.TLI"@S`>l.6-lj
Fv][˸Y$Ҭ}lb|4v9ȎxhґIi&ˈRSL#+Dl#(َ6
wDs-"`t:L D<dбQIއK<FPI+.pTIvMlB=
uX	n#@Ӊ0s\BM"4-(9gg:usC27,mۮ1ۆё
f"
5ɋ9M|<cn̚rJ1i"4&ьt"Le{ԙ.=L*MbmrN=mW[#lQ&izd;D+oV<8}aa
Viq¶Yc&Sr(,}60ùnlǷI#!M
hVBBw!W	'6ɧf\iy
hRb͌w0
eM">4-TCgpvwaCը8ki%\%/w$E.pa%c刏h4ƚl	V|QpƵ 
͹Ã̌;p35P  y(.oat
O&G,q)8'\ERkY<tRushsQF8i9!C3NpGMC`oP7>iW4wLmpj fӯjw(I *frHO܀Ǹ|> gC"FdCd^S-;[ZսqQ@CⱂjYv0,7ZλMR|+vm31Ti
4·DS譜k&MXhb680(1v8JVCa쇓
H3 +3(db
(i*tW=4rP9SACjDZѥb

Py6oI3-Zj0֢[IPdd4w:E$T44[9\FI5AMSY0*4˹L	6ζAjdFhS,lll:6,&7['ۛF_dS{ߪye
%ˎ:92x?/_ćOx&>wW	m'[#M7]W]l;nC:sM+=<R2iSІ
Qʍ
mkE\{]T$
2CfoA45S}#b"d).2QQ9Xn;cbDf(]<9<ۏ9@ja3~$T<;#koӞeԌiYkfk0匐(qsk<wO"\<'T$OCG%kTe6F6-M5[R΢-3
L):T02uHΜ~[W]QR肎i>8`/gq4Ҏ&m6!m$!KE$BPEE2ff~\
z_i1*djWb͂ك$:@<=}$6W|[o鏳B0#f|O\=?͘=5<{.pQGd[_6_puT֓~]M?RAbt3z`5"sCikKO1&isg+dڊ]7ΓlE)k%?@ۼGsi1vD7b lfS-%Ɂsc,V8N\Yɵ9PؓDU4՘Z=mB!ߪjhgk;"b5U|0U[ʮ
yvVUU[5ۥ.
vNccm,UQUUng;UUZYUUEUUVʪjaAFbVU
q*C@8ی"kxHujMfj)&m8E3Ff#9^+ߐIql׷+UJ.05*Ѽ芊?`oCc$>)}F(]֧7(EأUǑ'dt80Z>@M%.M4v[Zه'O`@`?c\Y6$j K|<Իl@X0~CUx
?83m𡿌LVVV	A~~;Hr)00g3ÙqXOnÑrbMf't_
=mf_f( "J?($WO7t		&:.^7d]\^$a9#ws澦	?<:?֍7z`6_;Gt?~CF~ǯ0lFxTxMZyr HdD,_ޱ=9Q]$k}$ Be<[@<*tMgL9K]/_V^GT`~ӻ,LpWI?7<-S]I>H0@6ϝP/@2CR
陗u_S|7enǲZvز<In]lI`";&b]u#4g]{2wSy"E 3@OcMx2^uL{alBÅ#Bh49TWB%µ>7ix&6>ab6VwTCi%A2Hv_r!j8;'MIXG0`x*8N&1Jy6R 
y+KJovu8oUsж Q@{V:(SX&wqt1	SB
~== /JQVMYڎ30AwK
%;j1cxӷ2[)#Hjo~]=G)@sˬxw~/,qT
ӊ*KtL&ȅ$E}`H9 ]fezSQa?jF
is5I;\jl킬lw󤢿ŌmDJUW)\?LHeYuyd!2_IA 7Q+_@7@鎇4N!J&z}9>7@ɴt}~~<]'i`).`mBD&ǣcw@CDwX}М|[O~:V)ik}/ntl".gŇD0[Hۆ
xk{0%V	er4=b͵,*˒;84;ut׹	pêcROl# 3L}~$s55@@n'seac2A p)lPw eFo/^m?gC:Lg?cO4}mk}^w;yI/t4k}w;k|[mo^ێOrqJί]}ZFMbW_8貂$lvqWc/!ͅ>	IcͲE`hOf0%ϜQWxC8DB-`J
o]mǞl<{KŨ%pi.\e*_IxoCP)P]2 NamFʱ{ _
/XZ_kHA%K
ɸ`&bdskArKD{WH88
ǧ@^7`	/<F,ZrDȁQ,~_
Qu.Ҭ7z9a݃T40
%8UO@k'*F|v:@]:&!"}GILu{fӁ r0*_3/q.l߾2oKMb}5&2/(G/<MoBV`oPޯ
˷(Yl`k8q
j|O>ژQb`]!B& 禙kfB.*2g&(
umvaHl HyiaFWnA](7Hq
VU6͹jRD'/jV|hƊBv]i{#)
~FRƣw ;ӪWenTݨ`"c$VݍCUsљllMb9xO]tt}ugRLKjXfLY&sIYFԹY\/G6
d^KomiR7TF\'A\KNK!WutmmF{xtqpDwv}kxB{=6:8o뵩Ūq[L
8cW	 !J/Ͻ21gq	/3H/}s׌\vRu܏+M51֑Sb,F)JHB4[%s@䫤%
T]h1.XvnbSSejBLT29T&sFsU:0%Ual5m~Q34V2
'qqd㗦]*wi#oAF@PhyH_i
9,(z
ՊƼĒNP$aAj&}{~Àg_g*Ö6-b$=7
`o=C66i錇ho{1c;HU9em;| =ok:Xɳ=	daASLsHu;<ݨ֝}\|>NI,eIt,0b0j@#{b|5h%aˏ6[%W׻-gA
Q߮7l,978Lm[N{?Xo}\o}{}2;(("=|ց͊" EHg_Ls3Z2
(00D{8
'[t,q̔5TX;uQMB
24Ve=x<(3Pz	Q,ZL;Rȯvň!0"7(6v'$+,
M$:|NO
F?/mzyjgO[}o|@p0<i4EZ0'D61$#&',ō=C1#x=d"fx9]KH-)>zvI!@1j*0E# "HL<FJ034b)y{8$UTQWej*20e9D؏C䅇ES\9oQv-b;D+Z
K	!e7):I}kvh8ϳH~I\7:5&#:c]2-DI/3طg__#M}&5{76
آ{|Pfץ6b	ۮ2p$!>RN7FCfS=J%)UP!:{[4=pخ@`e1X^_0КN+zz] PhS`Z߁22B1aD+3DP#?r;˻23$|5O$Q;Cg6raYI(cNQ5;_􅶅< ⑎:#3[ZcˑɈl>;46c 0[4$Ldd! 
  łLR5K(;
j;>~u#(	3_x;:C:q0(ߏrsԤym?H\eG5Mnjoi,TCZ?xц{z \ہ@B!
Ea_0gk0!
Y

:B:y=n0bt45:,a&<u2FQaaE"!rLsUȷ}|6?g$4r>Nk]Eot=/jg8c3gm>N~c,$Zt
fX=hY
aßrȹӞߨ}]}TY
J>6|k;̱("QAB$d?00`\_ 0A/t(>oId=&#}2<>Ӑi״dÃS؈M&2))^Evwvr[44nL;GϷJC d6n0TaڂycD`Bupe2fgdl|C.,%265ǒ(,;|cV{HҦq^3+21SA+iof">_嫉l}Ĩh7U3^xy ,_띴k!Η6[Ǿ<#Kz%=as0a3<1#62BIׯ<~M%-|P+T6t[ :(s| Ѹ7i4ռkb3@w/C!%Qq""'RW)T6Y\dRcRd!	7կp}MKj#w7 s}|K{4z.-m? 6
(6g^{2LUUZ0s*ap܄Z29:ݰ`˖]:/g^`#dwZ ?JI%OO$br3s~_ʽ9X߹_'Jy6<|+ѴP57׉Nx!Ǡq4x$ocfs;Rsp_8 ˼OsyfI<8Ao'a1:>o{F'9oE} PI(N)V~qk~HIrp!,΢Ȣ=Ghv#Iw2FAőٍc8jIMPd;h-G
X)At@3*QBAAaIG|\x˗aQ=%a
\,CJ)Ն#`w# cc =R(Sd&A=H5  5@Ʒ]&
.;A0L`Q͉QFL"z=ħ|QІ̐K?Bd8f!@
"M?j֣ۀQ.> <BLĖ!I{ܱWK,\ڋ4p|H2*$;⬇ͫ[T"0@H,P9_6[a$]}7Dbd$4%IDM0,e%HE<n6MV'
dz}|#ځ٢(m! h'
||vDϫY?S&@k%BO{Dm~lÙX1@/=\s5;;=F&	zG9!Gjwm<g6w\dC'57em0ĩOIn I)lr
/<"h/3,k㍌\|TAH=Xac7;f!mQN'{kFfA8]Vl{5O>skǟ˱\i :&BM&d5 ]:pG,LTH80t; 9y6E?X9$i@ApEߺ'uD{_o3Fkn)B&HJf8K/xkr܂Zj-z墦܃hfWo%ڹM(q\C:лcQQU|ˆbڪmF;o8]@%6HŐf>X1B$wBx1MJ/6qaT!
.)=I8? Gɩ֬hL̴6gZFbmxܨ%tFN1]`,
y1]2ʄ@*L+"hżF\IAc6tߵqt*qAd5	:)B&4n`50fD 
\a(z$h6KAB8'NgqI7xzZJ389ҳ2f}IKkdU/cA˸::#@V1`Vg@dQ>~&fZi^
$4zyC$K"f3ג*\&"0+v6sF
k6{-́|Cs_AJ<)l
бA+STt\1*Q#BR[1wZ5fޝoj߭nVW\3Şl{-_k@c=i>FP}gvT"+Н=kkY(HXrQJL;Y3RKpQB^xPe[HsgO1fomob/{PQmNƕJC.ZҸYSD?ѯy|lVS>*NZ-F!!BC
J5YD69V%+լ̲gh
%Z/_SfwUWK)pN%--;SڬŃsyWĽr55s弐M8YSGY&
#"ƹ0bLS]v΢zqVhњX>[^vk\yɅǓV>zw1\8~ۙ=U7fsˊW=4ϳOskHke
=3(Yv@-ZF_=L&s,0 Ki0V64q ω>1N=25pE,e21
	m`dJ\{\)p=!.w3,QrE\8P@1噒%P]ƾ½I,֒yʨ#A]aT@jlzuiMoOnskX:';fL~Q\f2O-:u}[Y>\نhZ5svDgYVͩ,H4o9\ηNڭ:t2[igMXy>צ?6}ޏAо+=ެcVyOvGyw'D>=tʽ-.3=uˤ|\=>!˝zca<wws%}5t͏y?T\߇
;sz.^~ھ.[zz>͋[co6=rw<9Ӱ6`]~^wŎ}*6ðlinXc>ZpFTNŃ$߯7_oU0zKԡ[G[.Zj5$[.4&|xgWAcO-bSF]:>TbzF{3hV#^?qå\1A5y3碝n	
3B+lbM_I7RN<E&	떖*Lq65Tp0aL+GJ|`/ЪR8u%zY36PR!`$")V!hZGb%B"&R I" d@s'lA"M(Ϩ!o`PJd!لm#`A~f5ȅ@ja.CDpOzXZ;l_W=>a<z+BV!cAd @Ogrx`"
ecY@[+WqJJ5HjdPJQR;=:ZvyBI;cijLlQ!Df}NF5e1">=\D	^F<i^&`rNC{
㒶+u43ύ!`Ju@ހ}c %
S0=TmV{6sмꗚ6鸐Ǒ~ϴ
<R7}Jc^QqAYa6,>lRm]2ˍ?C	Qq̫/;|<-U^;Ӓϣsscۿ65:櫒ٯ9RK
չqQT@h>;$v6A='iI
³)nl#\k6Bp.iVM	F!
6ez聏uy+Gȫ@Y=9=0`P6k>q!14j-p$YpE.yHB3c}i-h=3>!`k˹_.+˵FQC&LfK9gh ԠGAɏ,/LH-#=uA;8z]L8;J;Ks!?j4A<aGR%r|8tAF"lNA],1sYU8ĥL&ȨJpb:rLL	ƚF䎠U<MAphN,UA34ʐD8 XY@m61L
.A422	R4hlR0kp=랩
xi4Mas
t4uDНGX6@
d\ڥ)	Y~	;5߇VC=G<Fkb]	'!lO~	>O#}zZ2cAe'yг[=wt.]T=MjN%kְON'	2jZ`h;
4po;>33hhm0"3=MN/|Dj@e";l:i=jGӳ^z?5l$澛]>T>lOl2KYjQR0͉ܰ\L,d̸I5C֌hgMȶGQMQT4-r߾5bSRU*KZZ0Kl<
,T`CEߣ&	Qj0VpIFI18|wXuċp#ADU!|@hif] _ϡ5DE s#c
  !")J13Jڝ<FSZ:͘Nx]!3Eqp,RēTX_:uW"(C٧AP:dlD*	~ yDHBA(!!͡󞴓o?,\kNP>ks]  ){8<z<X8E4PDq1l69AZ	%' J@).Zq#J@9mxnhaP)!}P?Bw8k'$BZQ7롒	?5;օ{]&umNby>ݩ2	8aATN$Fb	ћU`ی<vE7c2[^ZV{SƯI-+mPnġPlHPߜazmI取fSf]NJv׫;S+aUӫ3$-vf\͙5HF`MQ0RBo7PtGe椓f{_[1wBRT-^nn8)JB7#2ϙrkх$@T1\$VO53Gۦx!BaQ L55{V#ZzA!s3R1lNF
@6Ё9IŶy2o9hN |](j!ҩ")&D\@rWpXRB!vRB&WbYw@JlI#(++LSZ@I))J7Wl/	>D	o'~?j@dv	Za)BZT;U̦2`KUɱ|RzU[2("=t&wK$OZ)
a5Вm-1PMIkؚi,ZH5gtP8ouHo
7ghi#Ŵz~xrD/.~]Z{=	0@}~
mԽѭΠs+VtDB<rv@6eA|xr{ ti5-ӟy}'A{#ϯѸwMéi mȰyTc@
%s˺T(+jitFI0f8bsw']he6$^Vi?-cy2u;86iYk?OҠnG4/TjaEd\T{ѪBH!mdWat;UhL)votY>ryJDU1A73~1s 0dL[൤zO]U#7VMቕ
.,B(h$
X&!f!qh0~؛`
2CqN'Y,P2U/ϟ2^ @Ri
ɹe >E(cIu\"Zzԙ'ug
\ʒlۛUk	CˈÓpޱO8:yjˣ&(MVIu*=P
~f8
zY1.ml븩[zuBJQvgW| =IhQ%FzFk'溚@[t"\xH. een@zL4CG|
:	M0Q 9
7{l|<#HeӜ͢VZ/ZRC*4	2g+
`hnA>qnz)sK6
,mBG+=BBB-=䉔@߮|ے4#$(Q;K&[ٳ|ΐsfZ7Rf|C0ڂOº<3ݿUBXqbB	.w!e[|Sdgvl_:؅>Mt̹D!5!ſq׍:$V=ў!Ns	=7F6(!Aӯ9Y(zydMi1eYxjScyKu['	Ȫ!t1B7vX]8=Y5;l3
@ԃ=ED1/\aHkYf$Ryn*,D.ψ1vɣONRAdÔ8lvP
7b{olk-k0kQ5O(9Fw4wUT]l6էj4K8PӫZ1@ihpFFsӳǧ;^ĲI:\upp0Z0|no:Q{Xo)?L廉@]]ǁ0ah/LskVM)V0ޗ.̲K;2Am23pCdjcmv\.vqu?:v93>mXk{87e!糥X<<yQV0 EEHQ׾HCz:&ԟK(!I!Bc$YfLlPa$)0?wf%3tz5x#E׃8Es#|6qߜ??<,x?Rxromڷ-9<ݎ-ֿ"VF'M>UŪPl=Kbz=>drV]*Ev۵B՘3pm5q
r.g]ɢ
vT	aFk\toʒ	q3?LkU}<Q)-7n/xql3|}q'o26W4a(	**:o鯥~+]ê#WY^vsƦݬ{UlW?;n=pLvŧܙw!Ϫ C>)_Y綺zL<x9zduCP8qML9~GON3fgy7$]1y,힌	ct}^;kW,3bwyzox~gk)Aҥ>./IzCX5Ջ}tԾيeͼ/y;k|8+7"VyǗ>;m<=$qǽ;
oWqxT8\<,ogk៿\)}ܳn??p>|6K,QgdW`="dI"Ft&*|k-g鷳ǈ6U(<
9cJЋ(0I,ыFlW^=1~ָb?t_TXXi=\]kHoq)rxck%u2hQ(Xi|Bs%"'"Co!XQr$dƱަc\,wz5mOGE¢0OV.LRܞbG?#Bҡ';'g=wB?>DPBN:e,I@n	Ŏ*xSI9Z
0Hs0nqDroNHP5aK#lI{S8{ƅHt-gj)#>ω:lPckX<xK8 XKWAN4ih9KXbѻpS#Z9+h'$R.\`	(~eGwk.in!(m݀ʓsws;Dxyg"SNZ+G;لDA@fCM$#d#m0#NT)i]lXaK(dXD"!NCzO]Nr?zrBF!l';_su1B{tM/D)h} @k;;B0(J
bBXYU T!`p@fzD?/mO|ɖBߝ*7)CCn2
9I34VkPr'gP;*\\Nkt3q^<^*]Tj֐ds;"A"BEDxZҔW[~S1uWP,+,<CwZ>WHI&AjP܂uRZ+8o%2N-ӡP2ҟi7`n;XMiHH/1PSp`c1=c]WXU+4+|@ F	`22Np`lNm%=k8n>RW@ XHA4NEa'tcCK@񤅯ji1S6+Ui!*;Y~niqeܞV+Z 謩]Xbͳ
\RL~*Hc,)r#F:j<yL<U`a fpx>-K0vCB	$Ďh򗫌<TiF"PޫHnw<ddKQfaerJbhpdiJvoB{ش)"b>Rfbg@14:,ZjI MƱt`R<Shk
&pI	e;JB1Oan_=GbɅ%YkbS=Y6Ybi=ʊI)Ko%Q?8YII " P0bC c(A@RI0e &*@BI_n//ҩmLqVZr*5uޭh$q|)Bih䂃tlkQ))8@`:
Ͳurz4\jAZ%0E}XR'܋NLD	jDOEj7Xf6^!#sD)!A,[7:&Q?16gLahZ789k(_ys`F6
#|b2tg
<\cH8GqqVC\(JW<}URCa9]D&#u.t0v)ɐR!vpf^g[t<u\p!h$@f2W-r(wJ$]K+@ϡ]\
	Bŧy@bL/Lr!߆0jj<$APVNgOFQ	EddFX_`@lTk@--q+9`h@4r
!M`A@0aGLEBa(*'nVtֳZ?O ОD#/*Ĩ+{JC
Etc@<nGUIpb1~p6N;;ԇf0)P4x{@k{#Y0C8Rb0bAqas9è]3N(OHF2	?$.ұޡÃƆyBl=P/_|\ު&Y\}n!8b&*LS(9$u`{TѶ:P{q>V\xa,+Oap/3F_M8\};mWptTh#/~A$26ђYPYM(<8[!\ccfE_2rR:@-h0m?h/tK Ubzw+hؠ=),A
(7Q¾	0CBgah"izz I|os$s|r w=`f6.
CqG5b ?J9jx f@|mf~&VA(5Rhv7lfkePN8AbrӓyN\ExU2Y!UmU8m!=A<Gh
I	'[cmSrSjqs#μBΨ;x0A8HĸHd?{Ҋ	 BI
x-m( m}i4:;
9ƒy~Jv>;e<F
a[PqbVHXS$Dm؛crA /:l:+"aШ g9QfTbӳd"R&	HX9&M,HTFJ @ˍ9
e0@$"/30

z":<Ab$bXI"4.ԫ4i`AY]nslQR+ 9-M 0aGHFyGpbQ`Le'5 XGRe8Absry
66!Cr6Ӄt/f6`ĠePTzX"qzzViH2^Ggbkws ";
lIҠ4q]"}&p\+-bܲ\)c:>St"<hALx(x׽q5eIF!)5UPa8@*"pxҿ<E
=S+"Q c#h!T"DR"
3qz
'(cGi9Bj xu{Ш,kБ<]HfxXXJd ]"m,G<M!g7مY+]co]LBHUSl"],u}Y`CP.x:Yb'>|wK<sfѸ̐텑id~s䫀'=k'V۞衑RtZm],+oرF.lg3'6f/(L-ar9&=[\4qj=@W
6
p1.
qz̩ayJ[	/K\6V
eL6뇲>C/
AL +SpZqD_"4PʔPA$|B `ܣhh!iWFՊn;Mi}IҦ`	h	rL9	=R[MbƳZN]{p*ᗀ:0 ,TClhјR8TboXևBC2@d BjǸ
3֊mr/2]'",4P$7
H4
)h2`4 ޒPP1WrQ@Q:ٕ,
DR]q-;!	T@=tHULB 0A{̯^D֌u.GBho5|XOcq\mq<&O4I1ȬHglher ^ADK2GJ"7
	.$[;&{0n9
.AT9wZ'
uZmZCֹAAr h>R:նe89a7Z ƣZ
!TDƋEYxoL]gP9I'Az~`(VyY۠WF~U4l)EEL4BdIhk0hߪ{R-q"31߀}=&wmqT32L\WM96|+5aIǐ|YS$ܪq$V6-n|é>:D2O@ظ2)/,p

 AJKSnH!de[zࢄd*+4B:4dڦ<Thfwm\pLrZXTQ5h~Q:@p	mq.HFUhÃD43@v+F
ŚaHzQD(9j²"kXWi.!@ؐ
TA#@0P1"XkXi&/{Oc cǚG;]~Q]|ߝ;8
H)VjxQ@oLPe@䣛b#x3+; `bAYC&.uJNGhyDdr2يtp2v35ذ%֗ >P4rCVX,y7~KY1#)#btt`1@l&E>:kL Ϡs[hu)d 
=QT[44P$ g
fl3&KG%qG APBB1 v9!"pI'ZҚ	ddIϭ:>:O>&;98(@{#WAlrpڇ&;T#NH2ZBdnC!#sl=F}/[bW*#lGvP	Wqp6җr\37Vu0.4mdߞX+>Tgb;ZcVjxu)fVSWY_;[.]MT^ЭIHw? pB_:g	UO3y)'|WIo7$hP?n`be}VUl7KF8mP}GO;c5!._ [`1L$A}"|z4BFXFA1;.N>`i|@] `|,$`$ܠ?-~*HLΉn6ߡ쪪"$d
t|=s!:)n0Bhy

	I	W
:lm! Y;^j 9	TLf6,:a-t.n#aqle
Fِ7<? 12DR*.:;;VxZ	gc33t9JDQE0En9BDRTUQ@TUTTPy3j**<15	3`t8"p
*ȄtV, 0Note0$#d~E	7胪i󀱶N
 j
$*A(#9ZHw
(ͶZЗA4	&l3(83Je:@<A->a]]s`lB`bx$4S@fu+ϋ]g~SLC9rxb`kn:
6K}nU٢v%|E	
kmJBHhYbI9'oupMELEt#ju&QwJbK$΁HfQ$&xӝ߸PT5щ܆
_S5~Orj\Ӝfwxvun)TcA!{c5PJ8ۭ9`XH²_;+^"@UvuS$ԝ3>"4dl6	uaFӺf[8(pV2X`@[΢ qpDrS懁y]!(032L 4;ѥ6 k.tP15\fEp0llmEnEgDN$Pp\pqظ% cæ1BYTS9mBcWd+)JvffMf]`31.\]jKe8h	M$1O:CfU 5r(^ϨqA)-,ԍD!5{CKzR;0x*ưTR0*cK0>X(HJ!>L"gI2a#b *z!䱓|FKclc9hkrr6rSN3XRjkl%GJiLի&fHnAlJ0.Һ>@\4KrLr.@(mpTs\Dq #t:!9Pp,K*1, wE3KX9J>aؐR&*xmrÎ8CC4	|?>qft| 
*E>nL{B+r  tz*[:3#ef1Mɨ!NYꟳhaD?鱖fO.$B>	(J)L`BS HъHDZK+dbeQDB	NP绛R>ڃxDFF# 6143NGWAv"dB**(Jv(
FUHC<@̪ܘ<hA\3m2[	E>+ lC @(u8\.E!:n"
*M}s-B1a6Q4+$%!
|c }ղ#\E [Ecr$9HۋD`dXfQk!6Pθ& Oɠ32WLis
<% ~>@!0xm7R3GkQ;
LBۑR$^Aedx\.[{aX#b`W<ר$}$ CɇԇKw>PGᘦlBx9%j1aX(/񭵆aAlW2 Qp;
zO.3[xXja$P0K$}ctSКc"{;G@	.&yK8
)(Q6V)$IAu2 @@Sh֨oДN3Wh)a(h7_/,FQSw /hr7 IA~``؋þQ7ԏ#ZfkEΎHSzBY-(4pNBIQ4]~K"}ӻ'
b!&tH2p<csz(
?X?=7%kE73Q1鈔Noc1kY\66ؾ'o1x
<,`Bd
 Ir
/a~
Ľ~es
oaRT1eff#>tՓ<wxRJJ""푙'Gxha9#EG8zqRT[ZGYJ9rtܵL_S{|#m5`p#ʴfPa@iI
+P
lfI!h ml BMBC*`21B)5eYfpmR~xV7X[3ŜoKI#ZhE@-FjfP¤-v\O,XhؼI$X`JT0lQ"),"BJ`J68(t!4H-Uu!BRTcOhZ17@b	CL$2b_nmekl[a#$!! 8wc $jly,H n~c$l&Pi& pnF\+.E<P64m
xfٰ}tVUnEs3ǈM,dhi|鴿{{a(W@dC9+i8ỳKrAA&}Q俌:|rT";!MbpVRrɌeK8gb
ЂiL1T]{$ƙTOw,e;H)-aBVpߒS0[!%@m1f
YA/=\n,`8cu]^sHRW*Aȁod.`/ʳ"B0Eiƅg3C@q+V5lqhЂjApf˶eUUUUUUUQUUUUUUUUBQEt6 CVo.yb"h$(#O>b"6fg:ە$s7fWƊ9u-&/B
y@lgۉЗT%\6! .hUOv,,8cd̥7X01f*XA Z	ΆBĦ!H)<C5b-h[F
ْI1KM
(w)2>MVpjʰRmzkG-].R=m7$tC"
ȊoR̌ih/#m6zw$c̆FnKtUF"15ru,4)Da,I2
B16+(!4PbƧbP]$l _cuFӈiiA]NP2CEaJV>@0CǰKX	d 4 x<GY& uBHjmPwrEqֻGfn91έUp i!MbИrhgf=Rh֚*{Liv?udexcgB>yS6C E0&@g8ssw)jh^ݍ0pB@>h=cC^a7TH91|Z@G(I xzf#N}!v66;Mxу$$>mb耊%!P|Gg(f)Px%y`";~3ܞtt%DEo''[LCP]˒[3
F'dl#fVX{h<Kt8Pԁ0.E'P{]7Ah.PhDfDll[Mǥ&.|EAԚs!nt,*
	 _&)߫߼/H"e<#9`7
Ɂw%CBR$=ACC
|v;LXY|䆎ƛXSAXAMkF$FBFM<2DDdKQEUTQ4LUTyE#Fd2)EflJ"AL(@}p:7x==HDJ^I:K̄H`9Ll.qޅ!ovNv
rE4:Ԗ!5#SP`Gd,J0aϜ:@УDI)yfZM͏DA
4Ha!H6{dGwAtW 1Ud6NxE@ɉb7u4Hp3XS
x>>kGIATUj(18.	t; ޯez~"u}hĊ\HhM528}`^rAmdd`$n1n2
hiumM51ZFcg+(TmtRC $~ <9Gdc7m768"r8yt/Z񇾢`|a1T-QeCgr>
\~<9cɚܓ+FPFC_n wka,.*aLQ4dlB$匍7;L15Ɔpx+!' Tgchb]K
TKyI+j
$&0pS9Q)R ";GC=rO$E"H1k!
.0\-!u X.}ނXG]ȊxJ@[{Ɉ|CP_
Qd%Y"x0mT\!lq.(@XL	unEȝuPP'p9awFDg@B}kxDbfX)>}x{ZZWLl8$ \@L*K)$,$^
+^mB*g"xfΠL:TTUQUYa9!&؄ 
0B1WB7hOq"/ 
 	U}G"R d|^PDo 1"j :=䴹4L]g:K ,W^P $I!)xKnveAιȚ
p,F
F<"]u@ew$_l.+>8! ԤRTH*3
̡y8IJ~MKQ%*T;C]
醸I0nE~ui[D4M>7z#F\|Iǹ YB5]t\ISqyKy`G.JJXWC:̃M I
8Fc@DA:`ňNJD
D3
"I+ m3G;	̔ pN@RaÿNh1,$NΈ5FBeG|Q4rb.\w.rv
^f;Yf&$@<Xh 1+;XNA`_:$5Ƙ#n@xQk\.H.jh
Z0ho
 F6
d!TJ7cd#d#L1C@5O|g1${:!^ޥ&AoE#ȽRUUUUUzP
}m:̄#d)"
N`h 8bբF_(
m9Fؗe䬚8@	>*\]>*ʖ@D
Dh\_b\O9uJ>]<(7Y^ԸsţPRDIwYXm{
4q+6,fG@4hm<w8vJb@I%ީIv]
ƴɣ
,iTB祉q4q
.6)XRvt7{XcXkV>=Faf:d "CLBm`Op{ Ra0(RxaVI?"ˈ)B2SRYۘ/5Ob|ޘ yOSl5UfLCюA
:0~ߗ41lsBI^;UJMkj(H/BB	3kVQ;6$!4HMTUkD
昜(DM"u;ul9U8Jjq>zT@UA7}n;-{<3a']C#kzlE33̷JC Xdlfxc1`r#:RwZ`Ae@6j>ȗ|"IB#ו6yS5-0]¨Zd
{()3b 9()J	޹eAg u'D
E@bPD,FH3-QƟcy\MLdV܉<<<6Ǜt:pq ꏿ AF`թI rd6o&]
"P
F'x'
_`2E2h f?lE574]eά5FfJageumT)GTV|u#@57#(˛$؏ aqBc(3a
 _2ˇUz @h'wz6lJtZړWK\)QlD-EhaKR$D+t+HOb
6*L WkV%oɓ3-8lPd-R!1.GmCH1D/)\M2<B;ҨA6di31 XbVzDF p,ƅNE
@!AijWA!녃4BLiVߢHXȣ);$($<b$C)9`GpC\=7Jp4ŋ*;٧Gxt!
;ds<-0$ H@xB.y52Qa///WiyEAw.!HIxLKsG!L2
A"!;%!jAIPӁ&RJq ""Jڀ
Quqpo@Ӡ4pӑW]AwG4=
L7,]9rA!/CWQkuotPb3_E.r2cTuAU7W dA&.n	w !!r8 h@:iP	S,Zbj$P4_e= 3{kQB&WoadG$ר	p)}XcT|2(A|PNE'j؏ޞXa)'L]QHՁ@|a9
,A5;ˑ:=#>8$%YI}/Tŏʤ1]Uec]	ƪ;^}.^j8P~lB=qDSv6lM%C9p@& ĝQ2+
D"(iGFژ%w=6جݗp!t<:w7P`*bZ/|L{SB&"R=t̉
q䶤
VJc	ZŎ
<Vm]%Bv62<	C
5ա6«	#Y%0"a0׬CHN{bS6
t5H,	 b# @Sޤ]=# 0wG^KI[$2*,2%`;6#,6#FU8"r8F "m%M!g4yC|!Ut똤KLp$ (QBu<gІVNNuFϻ.}nR	Vjd`THҒP5xXHy[H!"7;h~Iշ>dY$
G&Wk
7SQDZT*GzCt x$@呣ȬPcmj;0HeMSk(8.!zWGpաWx}%Ch?hP> мWJ d;p X!jm,c!QYn*`@鷈yG}$C&e1V(>u 4uF 'xvVXv!@Zul ]BovJoaGySOJk,T?F,bZH xT~9^4pؖY@QĢ"JJDuٶoxп&
s3Ix%ZlJ:8ϣlu]TPEIa,t'5{pL$`jD@2Yۊ
$qipRDlNC
Qh 4VfmĶT;72F[hw*1YUz2rN	yoHpjeՒYݴ2
cXp8d#vӐLAbn<
@΀<HAZ 
p"BBO|w gɘPRop5|>(XڔZ`vϘ?P('<AYЇ7AAbІ&Hh;;h>HszԀX27Y2jpd@e$[嬉QDA]\jTI^#I4ͻA2J\B1*<M@s`C|cIxR%Neh'Rl%8DKzC@V@
Whw {c`B@;`(R؇x$0S!tGzTP&$W/8%{
询,Q۽nȡȡxHVOH;f8!yt
iP)	D
TTAU
D"P `Da&	 	R^Px]nO^QCsT@( 3%
16К a}KhD<cKl1SՐ%	%ǋ
	m
_pK)8"Ҭ!iT`J.,` .U,ݣCML%mIo:
c%YM,X$$ce"ֻ7ɰm4V#wmYq}3uia$*|i" !kfHh9Q'leTb,p6HeBAh"1K
_L
]B	Ӕ!>l|ĵYw[7MÁ'$ߎcAk1
\uXHfdqiu=D䆖1YS *f,lJ]o: fL_f,.!Ùd`K3u˃턊,l"f\i[B(`K.[FIANAX+34iy%eQ*դ&+؆5ĄAA`v 2;S#KPuJ!IXvہy|fPs
	 1D롇O5bm/Β$ 0:P*b29GXဏA\7H:@_Wia=(9$$ sWd9M$~7sÌ
"
B$X
 ؅^ĽdI:]*G&=9.g9>8gFļ4іmxD5N7AunDA):Wc1EGm@+_뫄Gl.sff{OrS!p(qG	6ضpP%H]TyєJE/ 0M// -,҈@i͞q~7
l10myRR um%<jtq	9nflm&0QB¸1C*@Q 2<cs5]Ԋtc7xtQ힠gwKGUfƣZۧ~Hv9*%Bg:y};+}NԽc]G06㼔'$fO#cR/~H܄$)jP6T `Qd嫬%bbg"MtFÃ(aCò6$ M^,2cPIqʄYVf̸&*nT
HO(rLõW$*kF<aTڽpup:šm9r:!'8`mc*XW9MAHCD [wA Y%ށYIp`[AAF XUFC[dh%"U(R88h#U<6Q-l$4ޔ"D]HQA(Z"vFiOߚ9b0xk"vlXI
z3ҘCr-¨ZLmor!(VKUG&Ie{Td3#BU -n
3:3E06FX MQp03b3 pBll1$R RDT(F+k`0`lC-#
J`8HbK5
88̪>QhT)Qc]+xְ62rSNfkK#H{F-.hc*-3 `bK*G(Y61Bc2"pen. (b1!FL0R D{C> 7^ ;4q)WQLC5:5$) A]BGx^tȂ"hx,E]; ȆwBPXg@FFpSbch,0Ao	k0	45cs&OC@B|y=-tjEJF{H	!VvB]]DyE:の'*H]Yx\r3bI$mi0A_պ<4xIbٗ1UXWh$8HH@*B
!	4 Ud Et7[Ho
8+`gߝ@1!Her)& r`q(^v

&WATUE2UUUWZ_u=4@0߰x;y5*jњ`XY<1N sSaݡ>&3:Å:$&P	uiN"]=posm=H1t֖N(PU"&˻k`,XEYju;:Tut)JsQbzpGc}_\~M!!dd 	<g,lq&w%Ihۚxc;D
êGݜOAf-
J[WE1!-ߩn@"!ߊF YH+xXW]w
A@z%ֆ Q	r7<?E,hdby^TbTD(;@P1P4L5 kܰȫY	bO)san?ǭ~Gش<sP!
/);tLA{14,|1>9COΌۅJTRQ81# KB.#Q$*eZv(RXOP*'0k
Kn׻d|a挂1B2%  I(`$D!EAO-zW1W@Ck1x"}}`pr  CDDLI#H a4G^GXEA:?!;% S`, h1"kxi`\fǓR#Ga8,PdQ! "bW捪zpz$I	@zJHoꍀsZ5&.WxJ9?1"Ogjo~f3J]k,0-G,+,^V0id(>.%bJ<gG4D/>B5X#jCk?'}FA:!d Y!(t5̌:9L(Q(4!9! w`RPȞPbC.[U'	Sf\B|}﹧1fS>-a/uQuh%i"

Ԕ M$J(&0®'!Fd2*x#ϣ8MG}
r=iAQjX.[]f7013aEhH
[0Ĕ#2̉Șslpq$1$B9:aԔ+J4cD|iF,*h;탰8w_K%"J) 
F@.q՜hݜfcO10<q
91Xh[vԣGDFC0c@Ƅ0a6-EI+B~kKF-iSOM(ǐ	.h	`>IA'Q ,0?0_F10~<nM~V@]nVai݇_?7nvz)$
=nJ_333%}k=O=/o>I$H03Z0#?]%<SfDې\ѡC9aae  @@=`Y0AMZK\q'fk׀ iD"~.P$P(QW7ӞT,/0,DF	 :Dflav$piwkd~s1B3@sp0b}plPnej mBIXZ;!'_G).w>T^u/ޙ~续P~9at&XS㙧V?w??ްMb?fpi`-Gqt
8>qŬvQ6oh6\
L5}ĵchC;Uq|?˒ɖUWOnN}S0ps1'W馕yd =0<e$,%<2ֶɠDa{8=^"P3N\<?Ts
M!@C?tIj6G"!cmGXȿT0( u@}r(/2W`@08/];4%E?Lcan|A~ϰLpNnC!xYB`Y(D.x3NsX! 3Y"gs|--U
	)aD49RUխ gŢ<0?w:l*a1ԻC]KP;,.t5!۳W!K|oa
1V#ɶܽq2a`Y(HR2Cs5
0ZEBӚ˿[";2gCgww~8ӻǱݻ<oILm4ȅLHfkGr^STڱ4qƦ!|X
ӇjC6)kh䩷CoGP>be$wn_7yq=xT%CA=8s#)utLRWԊNǷrl:K~ig	a0$*<o>fXbX*jVΑ@rs3փ3z1G-_B"UfnB,eWVW]r/ggx+KpI$I$6ߺɄM}w}w}w3|ψ3@ז*EUUM˒OG<}U\<o5
͹RA[@	V7$΀M]Mdlo9>M%䒁+9s$hZ|Bd`}0#(C`m8+&_L@S(ߒ`@ a(:7X6.`N=AXĻKG!d?`5Er&qA=O`Q<vo}:1IuӯR;7NmI>9IWj
v	fz62rpC3Ń逫OHvjet-}O-4c% ^!?6.d [F	2mm{P16pD3#tp$ J\*"w#&<c$^L{ޓ,	U0N0@cg,	4D:ljP=P$!Z#Xvv̆hØ)c׀YpK7n\8Z 	cmB`n!֑5`/B_a6d!Nsb"e  ֊<BZS_٬Jfگ8s~	$7͏\pHrڋ0͘S?Ej2Wֈd"?[C ~ -m1p:>To+݁u7Zx5&aMf`0(
hq	EAV ؄'\ q'D0}M 4JvrC֏r ϥ&tB`!06?60܆#Oc a .4|)"{TEDUbQxA+6Q="{t"/KjlF]_}_ufYұf	$hŗ"q,W]'[vwe*#?
dd-.*Eg}Рm_}sr^[z>:g(pȨ`u
$zT>?~-?Gv>{G|s[/sl:HiK^Ogϭ|U>#>/+-cKu]\uȍaO{ݗ*{|ot)B.'{~Mw-e?7vw/USAo?Stǀr}X' ab69!.-fr4=*
@C21S[(ԅ@ ?6}TMIugevm/m]g\6ڕ3.Ǝ|XwrҦٳ4tm1Gm=ޓm̦+^,Smu^2ݨkpcd{^+YKm!x0=8qkX98hhS1&@
~3N2"#vO6Y4JY{jf8:ޚi!,iz?P)~iAyi(me84>Q̩S|& (NH	@$`R!.b_STK~.XK^u䬓|/"(HT6O