#!/bin/sh
# This script was generated using Makeself 2.1.5

CRCsum="2897766844"
MD5="f2626f0b888e338d0fc66ab14ac4967b"
TMPROOT=${TMPDIR:=/tmp}

label="Enhanced Async Multi-Port(PCI/PCIe) Linux device drvier installer"
script="./Install"
scriptargs=""
targetdir="eh_async_mpdrv.v16"
filesizes="28363"
keep=n

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

unset CDPATH

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_diskspace()
{
	(
	if test -d /usr/xpg4/bin; then
		PATH=/usr/xpg4/bin:$PATH
	fi
	df -kP "$1" | tail -1 | awk '{print $4}'
	)
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.5
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH="$PATH"
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
	MD5_ARG=""
    MD5_PATH=`exec <&- 2>&-; which md5sum || type md5sum`
    test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which md5 || type md5`
	test -x "$MD5_PATH" || MD5_PATH=`exec <&- 2>&-; which digest || type digest`
    PATH="$OLD_PATH"

    MS_Printf "Verifying archive integrity..."
    offset=`head -n 402 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
		crc=`echo $CRCsum | cut -d" " -f$i`
		if test -x "$MD5_PATH"; then
			if test `basename $MD5_PATH` = digest; then
				MD5_ARG="-a md5"
			fi
			md5=`echo $MD5 | cut -d" " -f$i`
			if test $md5 = "00000000000000000000000000000000"; then
				test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
			else
				md5sum=`MS_dd "$1" $offset $s | eval "$MD5_PATH $MD5_ARG" | cut -b-32`;
				if test "$md5sum" != "$md5"; then
					echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
					exit 2
				else
					test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
				fi
				crc="0000000000"; verb=n
			fi
		fi
		if test $crc = "0000000000"; then
			test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
		else
			sum1=`MS_dd "$1" $offset $s | CMD_ENV=xpg4 cksum | awk '{print $1}'`
			if test "$sum1" = "$crc"; then
				test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
			else
				echo "Error in checksums: $sum1 is different from $crc"
				exit 2;
			fi
		fi
		i=`expr $i + 1`
		offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 180 KB
	echo Compression: bzip2
	echo Date of packaging: Fri Feb  3 17:04:06 KST 2012
	echo Built with Makeself version 2.1.5 on linux-gnu
	echo Build command was: "./makeself-2.1.5/makeself.sh \\
    \"--bzip2\" \\
    \"eh_async_mpdrv.v16\" \\
    \"eh_async_mpdrv.v16.sh\" \\
    \"Enhanced Async Multi-Port(PCI/PCIe) Linux device drvier installer\" \\
    \"./Install\""
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"n" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"eh_async_mpdrv.v16\"
	echo KEEP=n
	echo COMPRESS=bzip2
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=180
	echo OLDSKIP=403
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 402 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "bzip2 -d" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    tmpdir=$TMPROOT/makeself.$RANDOM.`date +"%y%m%d%H%M%S"`.$$
    mkdir "$tmpdir" || {
	echo "Could not create temporary directory $tmpdir" >&2
	exit 1
    }
    SCRIPT_COPY="$tmpdir/makeself"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2 -- $initargs
    ;;
phase2)
    finish="$finish ; rm -rf `dirname $0`"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
	dashp="-p"
    else
	tmpdir="$TMPROOT/selfgz$$$RANDOM"
	dashp=""
    fi
    mkdir $dashp $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 402 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 180 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

leftspace=`MS_diskspace $tmpdir`
if test $leftspace -lt 180; then
    echo
    echo "Not enough space left in "`dirname $tmpdir`" ($leftspace KB) to decompress $0 (180 KB)" >&2
    if test "$keep" = n; then
        echo "Consider setting TMPDIR to a directory with more free space."
   fi
    eval $finish; exit 1
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "bzip2 -d" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
BZh91AY&SYc FB    	`9yӀ{>  @.̪خcܻЮt}|>^}+h}Q{hXq{_G;+ns$zWUs7}E   πUIv\{׾ƾs=pZ,<z4^}u{{繹^Yڎ{mպz|*'fOwW>Z6{kg%I[rvaۺٻgc71Ez
e53qW]3{onvY}[nLկ\ՅY3r󽞳x6u{xvvfo[R_}>j{<
SH L  &C	5<S%6=OH4PѠJh jdڂfOjКjzi4zM=M=A4@HST&=O
~SQ4zS =L4S# ф D @#&!꟩螦)=MLODF@ $b 	DɦL*~E=触'ii2IA2Om*=ҞzF@ GSȒ?Ϡt9DBԀG ^g-HR$r2l	8pԆYuk:R'zG{C!D!0A@TI+
	3C#
L(G0"V8
u# SJ#Jҋe_svR"J rPz
|D<`DWt	)Mk	2BB%vb_!W):j%\f82K3I6'GTym@Le7)gM?%V_+W7ZhDG{5-G.eVXPd).?fۉvTFY;KsSBq.w\_G7MA"#(B)h)YY+00(()BLNфLI3A15THSI3k ut4dWtrHƨձ)"`)7s	% bI(%Zf"
*J)BiH.<beEQDa!ƨ¦i2Vqb(R$!Ki~	8G>៤ß.Olb|~
:KPe'()Jy)8aSer֩_i=aS8,7;q<y}r 	c?n	ϟ&c.0˙ưƓiYG̛N7ߵiu2YKS/Q =Hc+WٸzʙF[aD@7KGĝ>)5JRA7DPDDD a$ Ɂ**"3xf2o$$hJ((!8̘hJ
 R?Z)f"	&I"fJ("j)(}EE-3$XJ@
R!l*Xc .%G$e4S5AIKE1,DSR?)̣kjnLK'"f	(h$`h)/C2P#F0R420AM4W@ Hu8fA	AOr!"Z
f*H*"")	gL$ 2)((*iHXJjE!B%$jHN}":<c<=?*Õj,;	CQ֬VX%#3sJ/[sȧyNI *cXƘݚ
 <LVWif1A((M'&gv4AoLcxu!۱&>+:mT,
N'R
˯,B)a6Xa+W5淬43]0B#<%t&*.S1;yyG-G|7zaf;2Z2112!t9cq6w%
Ui"嶛5\3Dۯs8ቔmDxBd`ˡ{dD+Rc$vTE:-azViq¶6j?$8e1hJH&j8,m!]9Ԉ4=8$b;ky쁣]+2#&ԓSOM8kQic#NFxfw_?QӤ7&M7AjZ@mvc}ל{;gE\.:262taՍAI*bNݽDEDNk4ӇF]gu$&=AtszuJa$E:3-d!>}MJk3p.&mHPU;i5DF*b{CF[Nq4c|kE5Aj>&Ew?l׭kǩyg4c>L" ٳO<;OOSˑӃRNFK<is
ƈ*7֜irH
d#d8qg=3fܔ4Dgπ*w=lW322!wCsB3 
h
ƊF%"
(i*t|`:Ku [*id-k@SRRFq6"6$:a84:
qxF!$Ƣ*J
h(gv wo&f@421d6c%A	DFl]$us4xXUZ"0aqI!L_ 8LJR.yuQo_C\>$':	YS!'_6O
*1+~NX*\Z5;2e\*s:_|ihSQaHE5)*_⮑G|]V5x6FH&	_̝l~uEy8jƣ$Z㏸F}	
r ó@piCqMh@cO81MiI%Oc?P/iǌ6kZ|#c-/JZ'rf
3qnXTV33Aʽ7t疚V$hJ((	tV}-g}E2-zi7fϿBI	{7XuL
jEz>}]l2.sOohlB&&yNm
,o{G/)Iq:IRt&Ko+-
2-W3$[Qd
/w(D|v>T7>p@iEIP&1bZyPyyk{\%1ng!$G![fWu誘Q5UcUlm_NG\mxRۥ.gYr^eTt*'TUU\UVkVUUQUUU2X`EcSs+ (
UGnJxUd#cXEU-kIT
_}^\XjFٜxMLvp֖U)/"wRDS jLu`zkfD~BLSdu&֬Ο2Y;_-_HҨuc=yixD
m%y&f nZ đ&g'f7>71c
&6b>e͒,i83LϪ?Ѿ:SA޶5%y.Ovya!si b3?_U$UwCRrNg<NIQ/'ZVB[W;s%\4Z[k3I]//*sm4EN0<`Ec>#=ySkF9|,`0>(9k1Km+_K	6{aR]W&VWNaxG"Ȍ؛7>#4u5>zv6
owZj>Rڑv~TN14݃:qd;~q(L6e@	m)uءL'r3(N\R<XX	!&I $$ĊyPhzRE2WXm]0tx'@S$nԎ
OM!~83!p]+I 4b!"pX M:u[*uAĹ!1鮖`?6mEw@2"MAd2dVL:'#A!p4y?Pq
o`wᢐdV3Ti~bs[:@!|QT(w%d1<s}T[[[HCItz^?Vmݶ8goU`C$!SIa[KJE0{SR$/oGJSsLcm<l,|(u§ۆQH,>ҩ!"AePn|kF%bS
Hgd7.TT6>~ŵo.m&+
G}jś")7!I D<C)iìPg->ÿk;ލ0!N*5"l$8
'#To٪׈D
e] 9Jy]35ACIaJSs?y2~32ѳFy8tx#jAy
_t	Qvj!*"O"G?Q6οҷ-HGуm&:})䰦ɐ`E߾MCf飰#N77Ir(xnO2wl\sKwhiY
&n=icqڛLR[UԼzgߊDDAC0WݏѦv{X}<ھ%M>`e2S׳)\yn)GyMNk'Hpɯ
}yl~kkA69~}iBJBC$\~dQDoFXѾ4?Ьҳ!  /tY?v
(RW}mttXT+2@t8+u♯kgn=9]1;Y.9rx-7fgտ9~X۷Mla[lt~9@:KU	$D+EکORW_1s<EO
J6ŨWSϽk~]~37f<-k-Z.~\
6\̑D:#XW}U%v<RXE"5SNވ}io1ǳNl9tn
!8s]x}V[
b_'
ϩ9|!1bz`EPLyOSoQA
;m<%G&Ð#jx#=x$IB9?#tl(nх5I%r;/UGLSܟunJ hԏla2e8[
wG71V
[aqD
ABG'~׶9zT9fx"l!̾׆y
ņ"$$HTB[>_~..s>#((/5s9 "(#"*/
M(
_\U'<]q	(j)$bi4hrt:\%Snܧyj,% d)Ba!HE8nB!9 om&F=>2yOhQך<1:
`(<e
֛x@GQAt"'L*2TKabNmwH||&I
1fH#H-"HL<FJ03ކQE2sfUTQW8ej*i]0Ԟ~}cTV8X.W(®A&ǗYfF[w|fga}?#9ۻP!`+bnCEk'ub"Rg.==䏣0)&#@2-7;B/u,6rA#8	!{cPg]LxoGJnE5TbRNMWA106$ڛj5O}z֖XQ[/(QQƟ1~AZ
]}qe#[}~g"GkDF[y[}w,#.a=8&tRF3WF{;3j<KFF[NX&}~띾_7N ܵVZddda	"0A@Aj0
!AtureYp<{^
"9F%~<,ܲj4Bpi1p0Vx0
TKZa~'Z[>T܃Y:%.m.I64@!ê0юQFa C " +!AtHBORaPS2ihQEА!!8$ODI0,,(X_y>9eLEn4æ'tNp{ύԪ/9|Td$ndBZ\*t$'L
1r?.}i
7VNXPcEL1la>cQM5x[4g۽P|6eDj((^rփA~ZJC5Y,E(DEҺB}8qdCP3LEmF|=
2VL(97*!(ÕLdknIPQ@@1e>ǆ>T*>Q*:K)"pי>연BghF6
}5m5sC`6h_|yA6(_)z}qeLi!*}Z߭'~"֫f
čBtB3^&gnx:vi8OeQ:C>5FC{IUρRo]4z|C	B!"qh|gԀ(+ J2C#%x<92`/ГdW>Ӏ{ >^|罬=0]w2"@v)؀JSE $Y=?"ڮ>[eϛF70)"=Ɵڠ)O4~qϻVd
z8 ڂPg,/?}Nנ
!
iљ	_ڗ_}E'z3UW؛H.萁8KV4X^ɮ~6iG?t?b^t*r hLyj$Ux^>1wk4~R%
ThvrlxCA~f	~
9zGC4\Eu+tg=_{8ã?P|IBLLBP$TDLRKذ5~,*brlt}hgԸ'KJDr׏݄4.H9|'3MP߳+/uQ>?!u`#
CXo0:p	iDHCX@g4	1"ZJ!8*z%s?'CYYn퍌Mt<v050Z<2oXڞ;a(Ozmytj}cmn!`R9m`&l!:~s:ڙƼޘK 1LӬz4IlVC]Ac;9A^>x.&?>=~w>H.Vbd8KVaov_d1Ekzݝhb6"0.I\yp%.$$$R-bΏ~Drf0C$?ҪE+bs{'
kȠ	8vSTΐeǂK:J̍"XP?$QJa SN3Q5B8޴aG'W6f	 NZpLfW Z,8 {ً0Qnc2w4LF$sn\4.ΆZamf*h3
'`3MAUaOy[=[CliC>WUDRrj`rPHg&.7+98X??Atsg.nD/xDawo2ncYTSGJ&.w4Rhϕ`Fc/ŵhLco[dloop췻SqwN~M#NHͳH<QʬGE8[ˮ*sR.s6W;n!sTVQlCuCd%Ϸܼ?
c585I0[׫w} 4SMZ/~SX:R8 07ҘusߑcoBypWעw9ЙTvȗm~&9KajJL
ZΗ=8LD|YL3bHE-wR%Ŗ[:h޶jٮ8$3wE'w#9^1Q9@pgFk_D>.FtM/=Q;unlPIј^te}M/#(K!'ꩵ*'OLTNg<.a!
S$m9|=9^NZ.f7fϪw-՗G?ݑ^C9(͛,|hʛݘɋCږaCOi25t|.$Jy
1۳&eN^'Dx^J9ϟ)_
=@kj;0r1:ق372x_(
Y_CZXV0$UE3`c(όMkL;<=ǙʣΔjڷW+^}WmHjUۇ;מd,3c]k+
N&FD	 6qClYjlY'&XEq[>*Pי^npGT¹9A: 	YL
y`7$|q&K.GN;am㪣QNjO!S5[[1ȣ^Ë{yxU._LZx.L!//;vڹ*J(PEO\mmrbo9GcY9[zJP.ՅF&R	SKO.#&XS*{*Z	G٘Vj,Q1a~*v]C.&\U[nHs>ݝUB~8U)sV;wFGNG󘲕xWwOWThNswif+Gߜѥj_M=`
C`AyPmQR!![*DR@,@R-HIbP ab u/X.@275Jda*H)UL
{ 㩆]Nu%= *}!PMεG;Ե#/1"fauٙ︀ތؔf+ky$򻮼	kw1^C"1|'|嘣^ݞߚ[?&8rC<V/mSs,YA
|ǟv$7Iߓ
Rk˩("cdG;q9Qvԋʀ "3RZw[o~z,[,Z&pmuƏ<KE;fKn)02~$v7V%4BEc%p$as.ԱK
h5Ȣ:Ĕ}۳I]qĽnjڝkۺ8ƭ[ź劁(h(n7jN+MpL9i.6˦<ZSUJGU
a)ˉat;``C0T-lY;a-:~:`Y+¸XZM@kC))?_NV W` Q@̘Ιs1Ath2EMp
	tGz;--4"="F`%{QΤCpL
uRF0vN!j8E,ظp2LW")[@!MB@`a(f,+]HUy+Y"][M2š8PL02)
!#H9+CC
mH:i)4A{`PF
v`4pTWMOm\N^{iîtᷫ7NIʇQM?N!vj٭Ma#K"siI		!
YvLڪPLϕ9ُϼL~V|Ϫ{?-eT%[U6HlR5 `Fˀ;4D2Z2O6#-9sL#M6m񪀷*Й׻#>CE
f
H5@yN"󑢈oHy[Ͽû s#_s[-`UI$̂ =;(q?Y4^8AE4`"uH:-ٲR&hhmlt`Qhc/<Wf1
csg==nWA 8Cء9{5Y3XHb*y͞U=o1:E
3PQ3^ܾk̓úlv]v(cZ3jvbXsdm}S/^LD]`xK+v,/"1~	_l?{8{ƻ!bQ\u</cRy湃S2_e"_c5ҝK\GAW{%U37._Կob0YMb3 @!
SyfW\ZmCrY9SOtc2cPffg.ʗ]5	%ʜ-0I
.UA"rBKZ`^iL&iUS	7 ع ,7%RIKyX⑍9dtLyFXR9tUUσyS#MUUUQT_CeJC	 AO˟{ti`:7mQr^g	@^luhm5
vd$
ƼIzSeQ~Bޭ.zڏX
st#֌yD#̈́rtٚ2{Cc\ї>xN2&Y|'Gv.2=un	"DIrq猥I<%zTԢ}e3ϛ$O_fJvC<:B)$y\ɐ!b;90Ҽ7%rcI%8RERw%f'}u<yxќq{%DQx [QP_٬7f;XZ\dvo_8 T;JޥbtTɢˎy.2o]m굽3{)Bi.0t0Gsfak5\ A
TBjY0x^v6/K;~zF,V-rVmb3X\i1sg@e>j#!d"eY36bJcX@hB:bn^0ԁt3;؃f`·?S5Κ{'	,WioBIUWga1ZɀOGGqةRcO74ֽ>$G͇^O$@1}}a+ItO0/IdkЃKXi!zOD;w/ ;:ѩsS\MDk	2 A@hNяMvv" "Mb2C;ɚrW~07mqu !6ÆoDbG
wSDyc_a-ut~hN}b㰧r,208fHB#WgTWX|KUN^l<Un[޲<^QU=.qN8uG&nK.u91;sVNQ Ȁ @{}T-rf}^3pk7h\{6µ^9O;@a!)fehCI1v0#ߔ;gLzē%c0E=sR,\J){n׌ gbuwT?v5,3{xE&N/vKf1 opb?vx=b<tZ0v4&f6^ zeU 7&G#Nl6wAi#vG(s?v>W]ng_\_
SػF4d&8Zh=N}tr;E2{O?f[,a{>/ctѧR.X"ϻT=I2#$:!8AxoE҃:fR1eWg_?X?aõ-,Gv/ݼv"=yEΎ=i4CR#MCGʐ}󥎹nf_W/fVw3/ö"jDԭ%bii\#c̳*S^h_=b3LS֝zk 4EGD#2J*,"BJ{CjĕcVvOg|[Rkj<X5ءq§ǄU9P1b6`sR Rt9[W"7LSIoFE)R#}YطMgKW.Tp
l$\aٖYmPn;᷎*Mks
źeKXź((6:j_ѭjrɘ7r_ؑgO9l5(	V2^zQ{:+'5upSp,Hv&辙BՊ|}{2=DDD;
r&ct)6&5=n@ڡ_G~;ĆBCn({MCaW4qwٽL4,eQMߴ/a_Jwk?l_l(C_r492~\t!쿽H1
"&ĒgzĔ^bHb39m`11XpܔֵJ	4A)8:NZ}EX 4[tFo bָuD"yg߱ET=v#H!	x]W@Hk#)HFӲHilxK"PɶİD!
.+g'-'}76b.X͝V㍕`l@y	H4Ď? )S= HoďTɉ z;|^qT&><Gb?2_gcd\?FWM{(
.]׀DpmdTvPNÒMN$
dL42"LT!6`uYW&l0Rt+XE폨GBsѰ bf#	6tC.#Ol 6$-I$C%<̐]Xu30n۟w~fĥ3qfH耤rZh,LT5iN727XUsLpRG09ѷ5"+(ln08$9CiwF
i1c=Е ӻxCօH&Zz&͆6,UTcf̎"4d>E^Xtc͓9¯r@4-=;qq3K\i2:axFK:硜(=ך9҈X76,Ƥd 
2z}0AP y62Qq=<L"Z%	yzn31ekBGK[˚
(t!F=b hU"o$9Va96ן\VzL5E9qk<0p`ff.n}=#Kg>M?]!k80 d.4:͵D腎3=l8FOdSCP5!F\hr
$\r,"t np	Bgn%	Dy:̑@zr
Bc8Gb%MA.=	tv`eVRY<UCx`ҎvmB!9
b.OXU]m-psHu㴠GTCS@䯾w(=_Ie@Wc,F>ߚO6)D $!BC̔̄Աt,i&L;yL7d)흸BlPǋ
⺉"uD3QfЄ."ܴoVE\G
R6|8a}0fa zs^wlj<xx*r-c7/>;P̷rY:qFHcOI<^k-z Է/n945BBv9W&M
y<AUEU{_4AG+ȐˏGra[ I}I vfKp9k9Ҏ9
=䀠x/"bdrH1=lkJQAg$8'#8_>UﹴjY_!Qԓ4ei$$n-lTA__DcmGyit$;u0آ 5E֊	 ;ބc}=מ 5 ACSPl|xuק
:V?-K
si96yHHd^߱UlwZ"=хemmfxWO~dPf[~?'K!@̔#جK)D 
̽)!y;p)GP=&qRPRiܖ8H}#1,<^	 ]GaqC
#G\}}tfT42!2b$,a&Z)4,H68
>KPs)	 Xb]1(e0ҁzN㕶,1Tݢ1E3a;}A?9 DС]fLIܢy0ɱ9-cCLo;*%1(ӈoݸ^"#QW	TȄAknS@Mhe5lM4J$)|	&&V`\z1<8̌UlV~o g;cJ2q Øn ;@
zCD쿉l%(P `@5t7c@ZiFF0 vND~d~Hp;l&w	vv(]?lZ<KvD;5Gu)^=qPQ1#:
qW$Dj;{YorCTT;wegu4qj=@W
6
ǣ\>u2)Ka%k˄ee;
BjLMء|И4W0
AL p8!빛]۫A	p{KAJc>\ ]/?4IvMDpy#@ ay$.,k5߾EP;MP1b jM"QPBBC*H=1|==VqS# 
ر(2<A.::b0+pU"|e,K
*M\-gS <g9ҬZ_ɻ&Y;SOkJTF$^\>۔S3kIpA&v	a/Ⱦvrlk[OC"Tjy
&\BnP:	(pE
(y%#zޭ
[cu o
ϬX:%*
kQ@%܎ph7LQqҫ=LcQl-DTDƋEY<11w`vU5A\qՐxv:
r풬PsR$zv=7ws,HDD`F0ڤ6tkjȞHA*zA.>Sa pĒ̱LyaFM*wAE	@!=Nz
ǧ8Sjl%Y6q
%&Q@@)dd
yzCCو$)83Ȣ ȸ'*Q*7qKȣa^1
$+`j!`ZA}nD<Dg_|R-R|P9("7bz:Axxw	
<	vɬPMl@
#<Ƌc⯘ rQ6TأH ,Q	rո\4hSn8l >h<*w-fР}(gH$xR'l^аoee^!.G=xq؇qUNBMʟ.^=\%Ɛ03M;4mkŉ|SW|L켢I0QyX?c~k&?*c?H9;H%~37["
<[VuAA?'1<>a='a  B"tCp>%~ڹgCH>T
񄓒|h
룅5}yTIK$TU

o=Rcag4xlМ RĚNVc#I~lQFCGᙺST:9(&.]-A3f!5P]2t

>s(-SPwy۰j
 MQq33t:BDQE0Ep9KK1DQTUEUELD%:n[ʏ9;A=<0x#Tf
7Jm Ʌf)Q(Yv0,XawV1T5ӳAb@BgFUh
$
ޣEC.vf.>v2<PQ~0b>H}Ԡ}> mL0SA4
MB#U%I2}.?a
a?	';"y=$ QMp[B#8D\<MfP,X"hrHebC2 9&

ou8~?9)
ٜfbk0u$v?za/P`|((R\ a-AU%:Y]rMxl6	s<
9vS
@a*it,VI1(1huCVp buܙ={"
a6l<$oʊ$ߑhK@@l_d!> uYTS5kELk4BmmѮ *$
 	gS5Mz=kh:U<n5Cq9G.(fp
:8@cqSJS1g0TR2uULNE9kA
ч7("
lZc`,$!$!a=IC')/.bRG G~!E8ֶoa[BSO'UՖF71yt;[gEUe6V/2̡i.GvK*}Ltt. q/$Y1(r?Br,b -C^Q^&dPR4PCȞ;|!C4!"=@2 }HH4[)yQ#.ef1N	!B!E@D\YQ}pME	)@P$T(~ru gD]]# mO%a QD`=}D+Nc3Gk ~AI@x(|ѹGDBP~g(
FHWe tR9&
E>v#r @8@$D#9FwÌ}P*B.ay^bGQo
"$BW҆BhkQWKo-	J	kQ*4K+$	F^<]Jn麜 a	Ugcp.\,B;
s!Mي`504!+ZHh~}~?e$V</O}s&Uueh3G1ǚŘm1e6[_c<4Z(f?fT(NlJF.HHln,mƸ tG4DSΒkkS+0nMRUDPjSaV)$ I's>$9)'QE>r|86@μXTYGD?df.(btڕ*bg7AT_`Ì`؝,LiDa˹@1J>yj!v{&BZE1\̘>B"kts7B6Y8a{ݪ?tAeΆ$ϑǬ+0yqi"p%s}^a5s䛖q!ЀǢ{_y#q1C4LYe?9[=+R(V@T%2We5ގG=Ϸ`&IÑ6ߣ]ϸxɇ%ώ0
;z?Q!vpUĵMTP!EdPd-hH[: hH$#5`t1Qi.f"L:Lߑo'Gյ/s7xPmśbdT@Ԛ`*%X΀Ewц0~d5ޓl`LQ3FС,MC$ѳ 78%@ҁғ#:6ry
Ji,06a!OoHSQsz}uN
pd0'}6=CZg'7jA6'ekP)8Aytգ8jME"YߞB2EÉ PF<wnErS3
f'hDS m!$ Z4D^3`z,C1bAAK-X>Qa;yy
ENHEMRfv'3=z}okF~/ f2Hk  J6>lׇM.quM$A(,Mq2$6	!/#7R,AI_g0gZY\bq$އvbr>JY6':^VHc3ܜLcRo{weUUUUQUUUUUUUT%Qgwc`t>=<bh"" "HHI$"1@H$ f)F<ͥs6=U
Vc4ٜ`]4tlq	NxI$zZ6MfDsl+3̦`grxƭ'CDraX!q8YL$9D'cd!2F]maҤáQ	T<3dkG:\xf6ɒ: DڑlZ
Ø5߉WN8!$,@m*IxV}nmF2Jm8- C4HMDkxkH:͜+H lp;8up2tkF3&QhlarbÁmHC϶L,OlP2 k ?,5:&h\! d:uh裄62 yJ]穦M'~6ۈ)ni,0` U?`HzB+&Ɲũ4ܸ(Hf
?*,Cn($|Fٳt6ė)=ބ/`	c"i"Fe'7=oHfx7?v'aW7}҆C4A0W0x x~wn#ȬTotD!17B(yr;jG&mą_ Ig	)66d+pp]7Sey*òXFk lΆZ	]Hu@,&N6G8[< >()B$_qLVe	
6X0SAY#5
#V!>4:ܡ8DCQ1$EUUTL09Q.{20 jYx H$L zc^ \B!`bR2)|:L1/`lA9ZʉAa-Jl
}a 4O3%qa`2ԵtI)DHa<5htA19`A04"(ԓϕZ
Z"WA	HA
(^@'kiG
		( FL6b;"
9$
\ č&PSl8|0#(-U5/[;7$@yv*2DVhc_V&AWq9Qga^$vhjAB~LiKr<r_G+ewhd};
r#JFT+PNCq<ʕ24asj Q5 Nt_zp@D'On-łl
u7@ռ@u
[@.QNȎvGH@BV-#yOC'$TiI42%pH~?C,1rb/4r|a,<n@
XGh0lm	*җ@c@yo<MǴ85X랥ԺNG&nrFxlDr$"B@$Qυp.a "_;)@{\#n8I	!#qOF'CD  d-!zd?5ǑN(#B!5	<uTS^aДaIѥܦKp'
uK |%'I3&cX`XA^d/$.zUϭ<t7Fb'؇,*> q4nfL.*;.= &-Bߧ P(cB<ǁۮشʄoCߦ2=d4m0oOۡB}J 2E0%:'g<hӑ9Jś`{A|Ǌc2*q.2CXFqݎ60bl%""Ri3$t@8@Z
'|C3\>;'`
q/R=OZ;gc	$Y94C{qr=>#9HTB,nL5J(W  {cM_~?4G`jJ^W	F#ЌIO}BCT)!'0'D<r|}:D/vK**KK#Mf:0B%E[XIa@N02!
Ѳ E11_voZB7IX8۲6ZL dS]HUs$mVubhaJqh?/ {>A>ۓ޶:GbU!dW-(`4Jdx"j#]$4oc1L $ 28Ѻ݁f$ƸZ)a,7ћ$6$=n*J?LP;~gQ[!5V>;Mp;EP#hZ@HmP4(RxfKDQh)?.F<O#yxFRJ{K0_p\
Ɏԩ{!xOll{;=<=~ɩ]EX
$2OW3㾝 Y>І jFfUHAܝO&RQL~$0B$&I*`HXrih9IB#ȯQ_ ;e|U|کT(4	_˧{1&XC{ռH	dv3G}_Ex0K"Н-pQ".6p\]ŀv$ɑcxdEdkm` PȫMQn?JBb K̽z#C폳8n6C9c) 7JkC$dJ
£}bd"w"Dv3Ma*y4	~uA A̜rxGiG ^aDH!XX+5}
H,.ĲX' LQNײ,YމYBuAitlh(=e&|ׄe)Gb8iljLGAP~LK2!O|pؒ61BDHi"SjFfY"B1_BEbI6i HD:?rkV%
A#پ@R@V)fdL!lR /CvHQ0s&*I
ЅȒH`kS_-VEP^҉Q Y ( -;8.gtԢ8ƕm8

s!{g%C)9-oZս(`ZI*2~YfHswWl Jg^i3^^{O/w D4i|ĸj iS!rR  D0GbvB
%66:$HH 
1=؜hCojDp}n䲶5B#
De*flnp& &͂CB>e7 DQ;E
q>2ŐE?Pn3QNh!sNi7*@`]'K;&.:.HK$=RnM6v.( 2_2	Yh`TbDH E׫Ϫ}acVH-ש]P3UBEY@~3HB=3L.zQ@7W朏Xz
ΊkZlq 5#A<<.2 Jڢ6]/XE|u}y,UO}_*I|TWֽ{G^ꍥt	
Y8xxގPk\ͩA';Fj!a\G!H%e
:T 9׬t&^tSp%!R@a$B@rt9KB9J,^{Z
Reu/DAa1NQ@/F?A,3K9 {cCt2+-8TE!P 
_Ib
If9.D'zB͒8D)()ˀr$N[jd`;QbsٙUxaߣa߳tH9[#D
\y4MEkQVHhG 5EPU4klMQjhQ*)nڏBjM\,ZCސ:n5MZ A	 \4<vPfGHA{-Uq)

?{s%!e)fFy9@2Q%H"^,0-+g?"&}&"lC'FDdRF V"2HQbker	>cHbAT(T}%]e;S1+]ѢPƏyHVKkƫMqM8$HZd9iWN!^2:FP{&@sӭmp8Y`;LX!gP:`T!W=D+؄{]UE(S'͉>Cb 8j#IV;
&)D`y'.]JPvžk
I≈ (4.M]Hq6M'Y;9X.|1:ΥpZ"`@pG୪6b@0$<K?"h\S9UD}vŁuߘ"Jt)BT'goLjv
_S0b\w*0C>ĀC1a"<ĭʋP ^a.oRn*®]4xtd
V܄><2_D.	{h`@hH! V" iZ"d%Gd$$̪$ {P@@6!T	<nI?bF(>u݂Vqٙ/bz-Bn%c߫24q}Y,fƏf3LaZ3&	,ΐ9A8X
݅t:cmKu6\6ΖFhEHa(S7xoV3mЊc>ɬKl66,T mJ3Ź_W4T3ޯ4+n[W/Y_hΒvV֓!WyK,>'_~"Od%2~	K,~l?BZ-Ԣ}뱘aZCmV")m`s!WbeAdED		=R(f٬X!NJ`翮iأXnG֏Łu1%`8{DٳacV$9%1Dj<`pTJ>OoJxCaj3: H.(/} <{3QBN%Ni?QA$wzUh:_;2/P~_i&Y/g9w\88-h$i;Y7<u4DR:dKPB
W^?@3A1agFľ>b4іpf<b@{MZh0ZQ3	}S>`f<JS#ŉ6ՙ`{Ce	 KDzrQ$Ւo'CAmN/@}fލ-0=8"ws0ZYP͊*RҨQy_VGW0TEgIh` (|%%+
RbDmڅٽ jh&04;IP0P{q댠Qa9!_dSi+n4x
&D
P_"Lg`\Twr2ߝn׻ip7ƕq\Zeظ֘T `Qd髼xKZ֤Ώw2A7K	Jz`\k/c f̺3JԔ:h\qMh1z3t3cA`|r!<pup:Š..8!6J耓@ 0XMmi.;p5[ih :hO
A##PY)*:`8NS#~v+;+[s\ƞev0Vբ t0
`1yc0 Q.exAWHqyw\nV5"rwR؎Z%[*vAI3Ac Z!3h؈	1Zo	 pis@a"2J*0(fC
t;`i' lC/nc)Ф!@A0PHN N0$D2Zky=~SKޯX&>! jË=#+-CrXmod%pa0ހ)k8 qG+chf
J]	KU`<02b|!`[lHE&!w؀`@!GD8$< 7m5PJ	Jg%)aٲga2 |a臑R,$gOKjǖs1CK
f1Dz<\ICM`}0&C;'	'ő/bt s)=12+#|@PHLbZ_"qFɡtB#(xM-p q(]fd
MRoYT;)Ј9EAG1EFa]G8ѦڥGg#6Q𥺛PBH$Қgލi˦{-x۬c{kN?FQx3{}.I,Ԓ
Q}
Sqˊ
V%CmyQ!+u7awXN2QVq mc&=1
:IbcϢS76mphԀ~k,V4X	&(lZ((F7z!pś#s~OI( vE!M]ߐ+;,@V,HS7	:]å~6N
/&k>k(rL!q!1b}Lk\*Ra ATKnv<I)*Uimqӏ : y@D5]j/) H	C!S_x\#ڂs~0"toglR0HDDĐ4BJ6alHtBHa>9rn%LF-Q 
 QK_MU1=TL 
u $ L)$'J_%y=4c` }{	Ac^7Kz"Xr:ua!u;"^>qkp"k_8ߵA flhHI&#RuF\M	fbT$*.BAz@uEC|0Iͯ៴SBE"tUdHc	4	(ri%$NY 4B|li@DD&??q(4}LL3E2SE-Ē
$(,2&$$R! 323~k3O'er+ S3@CHLR@O?l~c?N_I%"#xmz5"Hd6oc3n 0!_`rd F}g>k7!i-Cc P?)d7!q )